var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"MAYAUL\">\n      <meta name=\"release\" content=\"2016\">\n      <meta name=\"book\" content=\"Tutorial\">\n      <meta name=\"created\" content=\"2015-10-30\">\n      <meta name=\"topicid\" content=\"GUID-ADB3FE25-DE50-4637-963B-42281D086E59\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <title>Lesson 2: Simulating the pants in a static stance</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-ADB3FE25-DE50-4637-963B-42281D086E59\"></a><div class=\"head\">\n            <h1>Lesson 2: Simulating the pants in a static stance</h1>\n         </div>\n         <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C8F\"></a>Before simulating nCloth on an animated character, it is important to ensure that\n            your nCloth simulates correctly while the character is at rest or in a static stance.\n            By allowing the nCloth to settle, it is easier to identify problems in the simulation\n            and apply the proper adjustments before your simulation becomes too complex and hard\n            to diagnose. \n            	 \n         </p>\n         <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C8E\"></a>In this lesson, you will: \n            	 \n         </p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C8D\"></a><ul>\n            <li>Create a \n               		  <span class=\"MenuCascade\" id=\"GUID-B1F8C507-954A-41E4-92E3-5E097BD90324\">Point to Surface</span> constraint to constrain the pants to the nRigid_Body object. \n               		\n            </li>\n            <li>Edit \n               		  <span class=\"MenuCascade\" id=\"GUID-9BB47156-0F6E-4167-9C6D-5223A30F94EA\">Stretch Resistance</span> and \n               		  <span class=\"MenuCascade\" id=\"GUID-E7687986-3825-4272-B332-9D8977DEE6FE\">Compression Resistance</span>. \n               		\n            </li>\n            <li>Edit \n               		  <span class=\"MenuCascade\" id=\"GUID-64158DB8-B499-4412-9E8E-48AC9BD6E595\">Damp</span> to decrease the amount of time required for the simulated nCloth to reach its rest\n               state. \n               		\n            </li>\n         </ul>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF44C205DF11D7D1722DF-726A\"></a> \n            <h2><a name=\"GUID-34C1C0D6-9789-4EE7-A365-DC323B7843E0\"></a>Lesson setup\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF44C205DF11D7D1722DF-7269\"></a>To ensure the lesson works as described, do these steps before beginning: \n               		\n            </p> <a name=\"WS1A9193826455F5FF44C205DF11D7D1722DF-7268\"></a><ol type=\"1\" start=\"1\">\n               <li>If you have not already done so, download the nCloth Advanced Techniques Lesson Data\n                  from the following location: \n                  			 <a href=\"http://www.autodesk.com/maya-advancedtechniques\" target=\"_blank\">http://www.autodesk.com/maya-advancedtechniques</a>. Then, set the \n                  			 <span class=\"code\">nClothAdvancedTutorials</span> directory as your Maya project. \n                  		  \n               </li>\n               <li>Open the scene file named \n                  			 <span class=\"code\">Character_LowRes_2.mb</span>. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF44C205DF11D7D1722DF-7265\"></a>This file can be found in the \n                     				<span class=\"code\">nClothAdvancedTutorials</span> directory that you set as your Maya project. \n                     			 \n                  </p> \n               </li>\n            </ol> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C89\"></a> \n            <h2><a name=\"GUID-08C04C07-6EB0-4747-9CC0-C5E57E04D734\"></a>Constrain the pants to the body\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C88\"></a>When you play back the simulation, you notice that the nCloth pants are now colliding\n               with the body and shoe objects, but they are falling off the character’s body. To\n               keep the pants from falling, create a \n               		  <span class=\"MenuCascade\" id=\"GUID-14A29483-4BED-475A-A2C0-FB617EEEAF24\">Point to Surface</span> constraint to constrain the nCloth pants object to the nRigid_Body object’s waist\n               area. For more information about nConstraints, see \n               		  <em class=\"mild\">Constraining Nucleus objects</em> in the Maya Help. \n               		\n            </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E3E\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-05A417AC-B126-4B91-BC7A-5ED37CF8E4CE-low.png\"></div> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C87\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C86\"></a>To constrain the pants to the character’s body\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>In the scene view, select the nCloth pants object. \n                  		  \n               </li>\n               <li> Right-click the nCloth and select \n                  			 <span class=\"MenuCascade\" id=\"GUID-13E9F55D-4491-4ADF-8BC2-81D8D13E1FE3\">Vertex</span> from the marking menu that appears. \n                  		  \n               </li>\n               <li>Select the first two rows of vertices at the top of the nCloth pants. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C82\"></a>Dolly and tumble the camera to ensure that only those vertices in the first two rows\n                     are selected. \n                     			 \n                  </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E3D\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-09AED61C-8287-4DBD-BB62-54AE5043A6BB-low.png\"></div> \n               </li>\n               <li>In the scene view, Shift-select the nRigid_Body object (the torso) and select \n                  			 <span class=\"MenuCascade\" id=\"GUID-08C97AE3-3CBE-40AB-AF0F-1E8773275DD6\">nConstraint &gt; Point to Surface</span>. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C80\"></a>For this lesson, leave the \n                     				<span class=\"MenuCascade\" id=\"GUID-3B182B3A-6721-447E-AFD5-119A81068D26\">dynamicConstraintShape</span> attributes at their default values. \n                     			 \n                  </p> \n               </li>\n            </ol> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C7F\"></a> \n            <h2><a name=\"GUID-B22DA2F0-9C5A-4DE3-835D-0175B71ADF63\"></a>Edit the \n               		  <span class=\"MenuCascade\" id=\"GUID-2E0FDEBE-8D7E-45F4-A280-C613BA5741AA\">Dynamic Properties \n                  		  </span>attributes\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C7E\"></a> When you play back the simulation, you notice the following: \n               		\n            </p> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C7D\"></a><ul>\n               <li>The nCloth pants simulate using the default \n                  			 <span class=\"MenuCascade\" id=\"GUID-DEA1C523-80E1-438E-8AA4-1D08A5DF3CBE\">Dynamic Properties</span> settings. This behavior might not resemble the type of material suitable for the\n                  character’s clothing. \n                  		  \n               </li>\n               <li>The nCloth pants come to rest state after 40 frames of the simulation (frame 1040).\n                  \n                  		  \n               </li>\n            </ul> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C7A\"></a>When simulating nCloth on a character that is standing still, edits to the nCloth’s\n               \n               		  <span class=\"MenuCascade\" id=\"GUID-F51822F9-FABD-4966-89F4-D961E0EAA5A0\">Dynamic Properties</span> attributes may only produce subtle changes to the cloth’s behavior since gravity\n               and wind are the only forces working on the nCloth. When the nCloth is simulated on\n               an animated character, changes in the cloth’s behavior will be more noticeable as\n               these forces begin to generate velocity, collisions, and self collisions, causing\n               your nCloth to deform in different areas and in different directions. Therefore, to\n               simplify your simulation set up, you can give your nCloth some of its unique characteristics\n               by editing some \n               		  <span class=\"MenuCascade\" id=\"GUID-6B04D2AE-20DC-4BEA-8AEC-5AB9BFD00214\">Dynamic Properties</span> attributes using a static simulation. \n               		\n            </p> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C79\"></a> <span class=\"MenuCascade\" id=\"GUID-57E1EF96-F89D-47C3-9E71-340E7E616FA6\">Stretch Resistance \n                  		  </span>and \n               		  <span class=\"MenuCascade\" id=\"GUID-BB9FB34D-99F8-43EE-96BC-B48DE6E56299\">Compression Resistance \n                  		  </span>are important attributes in determining the nature of your cloth. These properties\n               iterate resistance on the links and cross links on each quad of the nCloth mesh. \n               		  <span class=\"MenuCascade\" id=\"GUID-F4C73FF0-B7FF-413E-ACA8-328662C2E166\">Stretch Resistance</span> works to stabilize the pulling or stretching effect which results from the Nucleus\n               forces, such as gravity and wind. \n               		  <span class=\"MenuCascade\" id=\"GUID-6E238D29-D977-4DF2-83CB-902A41412118\">Compression Resistance</span> works to stabilize the compressing or squeezing effects on the links as a result\n               of Nucleus forces. \n               		\n            </p> \n            <p><a name=\"WS73099CC142F48755-789C4B1E11D24BE26D7-588E\"></a>For example, to create nCloth that behaves like heavy denim, burlap, or thick leather,\n               higher \n               		  <span class=\"MenuCascade\" id=\"GUID-694E8325-1AD6-4F69-B777-BCB16D4FF65A\">Stretch Resistance</span> values are required, while lighter materials, such as silk or cotton, use lower \n               		  <span class=\"MenuCascade\" id=\"GUID-938875A6-CFCF-4CA4-B3C1-2AFEBC9B5F22\">Stretch Resistance</span>. \n               		\n            </p> \n            <p><a name=\"WS73099CC142F48755-789C4B1E11D24BE26D7-588D\"></a> The higher you set these two attributes, the more the nCloth resists deformation,\n               although they tend to increase simulation time. For more information about \n               		  <span class=\"MenuCascade\" id=\"GUID-89B427BC-EEE8-4818-9271-59F97FD9503F\">Stretch Resistance \n                  		  </span>and \n               		  <span class=\"MenuCascade\" id=\"GUID-0B2F0616-CA6F-44F5-9944-6437BD8E1758\">Compression Resistance</span>, see \n               		  <em class=\"mild\">nCloth Dynamic Properties</em> in the Maya Help. \n               		\n            </p> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C78\"></a>Be aware that adjusting one \n               		  <span class=\"MenuCascade\" id=\"GUID-61B751BB-06B8-479F-898D-6ABDCB312E90\">Dynamic Properties</span> attribute can affect other attributes. For example, increasing your nCloth object\'s\n               \n               		  <span class=\"MenuCascade\" id=\"GUID-FE8E4929-1CCF-417D-9E88-707F5D8D6D56\">Mass</span> makes it heavier, which may require an increase in \n               		  <span class=\"MenuCascade\" id=\"GUID-E7F23752-6554-45D7-B57B-7AEB633C5C43\">Stretch Resistance</span> to compensate. A useful method for editing your nCloth object\'s<span class=\"MenuCascade\" id=\"GUID-D33E3C99-75EE-403B-9AE4-D36FFA263A95\">Dynamic Properties</span> attributes is to set one attribute at a time, and then playback the simulation to\n               observe how the adjustment affects your nCloth. \n               		\n            </p> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C77\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C76\"></a>To edit \n               		  <span class=\"MenuCascade\" id=\"GUID-69ED446B-264E-4ABF-90B7-115F796924CA\">Stretch Resistance</span> and Compression Resistance\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-5FE2AAF1-7851-4B07-A0D0-9DCD1553A113\">Attribute Editor</span>, select the \n                  			 <span class=\"MenuCascade\" id=\"GUID-951A60C5-B922-4BF1-BED1-317B7026E5E1\">nCloth_PantsShape</span> tab. \n                  		  \n               </li>\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-896F6F19-7798-4AF8-96F1-D2C40D67DA8E\">Dynamic Properties</span> section, set \n                  			 <span class=\"MenuCascade\" id=\"GUID-30DD27FA-F34F-4762-8550-ECDC2170A0E6\">Stretch Resistance</span> to 70. \n                  		  \n               </li>\n               <li>Set \n                  			 <span class=\"MenuCascade\" id=\"GUID-6D44DCC5-46F1-4431-9E81-C255EC27D326\">Compression Resistance</span> to 5. \n                  			 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E3B\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-B86EDB2E-68AF-4E9A-998C-F1A87FF16679-low.png\"></div> \n               </li>\n               <li>Play back the simulation. \n                  		  \n               </li>\n            </ol> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C72\"></a>When you play back the simulation, notice that the nCloth pants still come to a rest\n               state after 40 frames of simulation. Increasing \n               		  <span class=\"MenuCascade\" id=\"GUID-A0A6F88F-DEE7-4B16-98D8-EBD23B2B3DD1\">Damp</span> can bring your simulated nCloth to rest sooner as it dissipates the energy generated\n               from your nCloth \n               		  <span class=\"MenuCascade\" id=\"GUID-39881CAF-795D-45C6-9DA0-C8A019186592\">Stretch Resistance</span> working against the pull of the Nucleus \n               		  <span class=\"MenuCascade\" id=\"GUID-256E806F-51FC-4D04-8ED7-11CC3E48FAF3\">Gravity</span>. You can also use \n               		  <span class=\"MenuCascade\" id=\"GUID-24DF99AE-B13E-4132-8583-7261DCF44DE9\">Stretch Damp</span> to dissipate this energy. \n               		\n            </p> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C71\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C70\"></a>To edit \n               		  <span class=\"MenuCascade\" id=\"GUID-22B48A60-461E-4E21-A16E-B2D7CF10812D\">Damp</span></p>\n            <ol type=\"1\" start=\"1\">\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-FC57F167-846E-4C9E-9A2E-436A2F132110\">Attribute Editor</span>, select the \n                  			 <span class=\"MenuCascade\" id=\"GUID-76D8E3C0-9F15-43FC-8062-9DECD8542AF0\">nCloth_PantsShape</span> tab. \n                  		  \n               </li>\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-A65433DA-6326-491A-BA1C-735F042D8DBA\">Dynamic Properties</span> section, set \n                  			 <span class=\"MenuCascade\" id=\"GUID-3351FBD9-924D-418B-A739-57FD05A75B8C\">Damp</span> to 1. \n                  			 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E3A\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-29DE5D61-EB30-4145-936A-475BF8207FC5-low.png\"></div> \n               </li>\n               <li>Play back the simulation. \n                  		  \n               </li>\n            </ol> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C6C\"></a> \n            <h2><a name=\"GUID-C8229FDA-49B3-4156-A3B8-BA1BB810EC8E\"></a>Other attribute settings to consider\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3C6B\"></a>Before proceeding with your simulation, consider adjusting the collision \n               		  <span class=\"MenuCascade\" id=\"GUID-3DBE8748-5EB1-4713-BF1B-9EDE3E8BD8D8\">Thickness</span> attribute for each nCloth and passive collision object to optimize the collision\n               detection between them. When using a workflow that includes a wrap deformer, you will\n               want to ensure that the nCloth collision volume (<span class=\"MenuCascade\" id=\"GUID-D2BBEEB0-BDA9-43E3-952A-3A24DEB2CDAD\">Thickness</span>) allows room for the wrapped mesh without causing interpenetrations with the nRigid_Body\n               and nRigid_Shoes objects. \n               		\n            </p> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";